"use strict";
/**
 * This module is a thin wrapper over the shared libraries used to manage the content filtering service and communicate with it.
 *
 * @module @wontok/node-addon-content-filtering
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.initLib = void 0;
//#region Imports
var electron_1 = require("electron");
var init_for_electron_main_1 = require("./init-for-electron-main");
var init_for_electron_renderer_1 = require("./init-for-electron-renderer");
var init_for_node_1 = require("./init-for-node");
var utils_1 = require("./utils");
//#endregion
var initLib = function (publicOptions) {
    if (electron_1.ipcMain) {
        utils_1.debug("Init for electron main\n");
        return init_for_electron_main_1.initForElectronMain(publicOptions);
    }
    else if (electron_1.ipcRenderer) {
        utils_1.debug("Init for electron renderer\n");
        return init_for_electron_renderer_1.initForElectronRenderer(publicOptions);
    }
    else {
        utils_1.debug("Init for node\n");
        return init_for_node_1.initForNode(publicOptions);
    }
};
exports.initLib = initLib;
